'use strict';

module.exports = function (grunt) {

	require('load-grunt-tasks')(grunt);

	// Time how long tasks take. Can help when optimizing build times
	require('time-grunt')(grunt);

	// Define the configuration for all the tasks
	grunt.initConfig({
		pkg: require('./package.json'),

		// Project settings
		yeoman: {
		  	// configurable paths
		 	app: require('./bower.json').appPath || 'app',
			dist: 'dist'
		}
	});


	// load per-task config from separate files found in grunt directory
	grunt.loadTasks('grunt');

	grunt.registerTask('serve', function (target) {
		if (target === 'dist') {
		  return grunt.task.run(['build:dev', 'connect:dist:keepalive']);
		}

		grunt.task.run([
		  'clean:server',
		  'concurrent:server',
		  'autoprefixer',
		  'connect:livereload',
		  'watch'
		]);
	});

	grunt.registerTask('server', function (target) {
		grunt.log.warn('The `server` task has been deprecated. Use `grunt serve` to start a server.');
		grunt.task.run(['serve:' + target]);
	});



	grunt.registerTask('build:dev', [
		'clean:dist',
		'useminPrepare',
		'imagemin', 
		'svgmin',
		'autoprefixer',
		'concat',
		'ngtemplates:dev',
		'copy:dev',
		'targethtml:dev',
		'cdnify',
		'cssmin:generated',
		'uglify:generated',
		'usemin'
	]);

	grunt.registerTask('build:dist', [
		'clean:dist',
		'useminPrepare',
		'concurrent:dist',
		'autoprefixer',
		'concat',
		'copy:dist',
		'targethtml:dist',
		'cdnify',
		'cssmin:generated',
		'uglify:generated',
		'usemin',
		'ngtemplates:dist',
		'requirejs'
	]);

	grunt.registerTask('default', [
		'newer:jshint',
		'build'
	]);


	grunt.registerTask('bowerCopy', [
		'bower-linker:dev'
	]);
};
